/****************************************************************************
*                                                                           *
* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY     *
* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE       *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR     *
* PURPOSE.                                                                  *
*                                                                           *
* Copyright(C) 1997-98 by PSH //UCL.                                        *
*                                                                           *
*****************************************************************************
*                                                                           *
* This is Crypt functions of Soft-Pro HASP Emulator                         *
*                                                                           *
****************************************************************************/
#include "emuver.h"

#ifdef HASP_EMU_NT
#include<windows.h>
#endif

#ifdef HASP_EMU_95
#include <basedef.h>
#include <vmm.h>

#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG

#endif

unsigned char AddTable[]={0x97,0x0F,0x89,0x85,0x6F,0xAA,0xD1,0x36,0x87,
			 0x36,0xD9,0xF5,0xDF,0xE9,0xA1,0x94,0x77,0x4A,
			 0x29,0x55,0x4F,0xAE,0x71,0x69,0x67,0xBB,0x79,
			 0x73,0xBF,0xE7,0x41,0x05,0x57,0xF9,0xC9,0x20,
			 0x2F,0x86,0x11,0xB8,0x47,0x74,0x19,0x2D,0x9F,
			 0x79,0xE1,0xD1};

unsigned char MulTable[]={0x27,0x60,0xB9,0x80,0x8F,0xF4,0x31,0xE2,
			  0x37,0xAF,0x69,0x3A,0x1F,0x12,0x61,0x4F,
			  0x47,0xAF,0x19,0x17,0xAF,0xA8,0x91,0x37,
			  0x57,0x30,0xC9,0x86,0x3F,0x08,0xC1,0x8A,
			  0x67,0x02,0x79,0xF9,0xCF,0x80,0xF1,0x38,
			  0x77,0xF5,0x29,0xDF,0x5F,0x62,0x21,0x32};

void EncryptBuffer(unsigned char *In, unsigned char *Out);
void EncryptBuff(unsigned char *in,unsigned char *out);
void DecryptBuff(unsigned char *in,unsigned char *out);
void DecryptBuffer(unsigned char *In, unsigned char *Out);
void Decrypt16(unsigned char *inBuff);
void Encrypt16(unsigned char *inBuff);


/*****************************************************************************
* EncryptBuffer - Encrypt HASPData Buffer                                    *
******************************************************************************
* In	- input buffer                                                       *
* Out	- output buffer                                                      *
*****************************************************************************/
void EncryptBuffer(unsigned char *In, unsigned char *Out)
{
EncryptBuff(In,Out);
EncryptBuff(Out,Out+0x28);
}

/*****************************************************************************
* EncryptBuff - Internal Encrypt HASPData Buffer                             *
******************************************************************************
* In	- input buffer                                                       *
* Out	- output buffer                                                      *
*****************************************************************************/
void EncryptBuff(unsigned char *in,unsigned char *out)
{
unsigned char *end_out=out+0x28;

WORD out_ptr=0;
WORD in_ptr=0;

WORD t,tt,nn;
unsigned char n;
WORD *m;
for(t=0;t<0x28;t++)
{
n=in[t]+AddTable[t];
for(tt=0;tt<8;tt++)
{
out[out_ptr]=out[out_ptr] << 1;
if (n & 0x80)
	out[out_ptr]=out[out_ptr] | 1;
	else
	out[out_ptr]=out[out_ptr] & 0xFE;

n=n << 1;
out_ptr++;
}
if(out_ptr == 0x28)
	out_ptr=0;
}

out_ptr=0;

for(t=0;t<=0x14;t++)
{
m=AddTable+out_ptr;
tt=*m;

m=out+out_ptr;
nn=*m;

nn=nn*tt;

*m=nn;
out_ptr++;
out_ptr++;
}
}

/*****************************************************************************
* DecryptBuffer - Decrypt HASPData Buffer                                    *
******************************************************************************
* In	- input buffer                                                       *
* Out	- output buffer                                                      *
*****************************************************************************/
void DecryptBuffer(unsigned char *In, unsigned char *Out)
{
DecryptBuff(In+0x28,In);
DecryptBuff(In,Out);
}


/*****************************************************************************
* DecryptBuff - Internal Decrypt HASPData Buffer                             *
******************************************************************************
* In	- input buffer                                                       *
* Out	- output buffer                                                      *
*****************************************************************************/
void DecryptBuff(unsigned char *in,unsigned char *out)
{
WORD out_ptr=0;
WORD in_ptr=0;

WORD t,tt,nn;
unsigned char n;
WORD *m;


for(t=0;t<=0x14;t++)
{
m=MulTable+in_ptr;
tt=*m;

m=in+in_ptr;
nn=*m;

nn=nn*tt;

*m=nn;
in_ptr++;
in_ptr++;
}

in_ptr=0;

for(t=0;t<0x28;t++)
	{
	for(tt=0;tt<8;tt++)
		{
		n=n << 1;
		if (in[in_ptr] & 0x80)
			n=n | 1;
			else
			n=n & 0xFE;

		in[in_ptr]=in[in_ptr] << 1;
		in_ptr++;
		}

	if(in_ptr == 0x28)
		in_ptr=0;

	out[t]=n-AddTable[t];
}
}



/*****************************************************************************
* Encrypt16 - Encrypt HASPData Buffer (16Bit)                                *
******************************************************************************
* InBuff - buffer                                                            *
*****************************************************************************/
void Encrypt16(unsigned char *inBuff)
{
unsigned short int rAX,rBX,rCX,rDX,rDI,rSI;
unsigned short int mD5,mD7,mD9,mDB,mDD;
unsigned char mD3;
unsigned short int *in;

int mD1,rESI;

in=inBuff;

rDI=0;

mD1=0;
mD3=0;
mD7=0;
mD9=0;
mDB=0x11;
mDD=0x28/2;
rSI=0;

l1:;
rESI=mD1;
rAX=in[rESI];
//rAX=in[0];
mD5=rAX;
mD3=0;
mD7=0;

l2:;
rBX=mDB;
rCX=mD5;
rBX=rBX ^ rCX;
rBX=rBX & 1;
mD9=rBX;
rSI=rBX;
rCX=mD3;
rSI=rSI << rCX;
rAX=mD7;
rAX=rAX | rSI;
mD7=rAX;
rAX=0x4951;
rAX=rAX*mD9;
rCX=rAX;
rAX=mDB;
if (rAX & 0x8000)
	rAX=(rAX >> 1) | 0x8000;
	else
	rAX=rAX >> 1;
rBX=rAX;
rBX=rBX ^ rCX;
mDB=rBX;
rAX=mD5;
if (rAX & 0x8000)
	rAX=(rAX >> 1) | 0x8000;
	else
	rAX=rAX >> 1;
mD5=rAX;
mD3++;
rAX=0x10;
if (rAX != mD3)
	goto l2;
rAX=mD7;
rESI=mD1;
in[rESI]=rAX;
//in[0]=rAX;
mD1=mD1+1;
rAX=mDD;
if (rAX != mD1)
	goto l1;
}


/*****************************************************************************
* Decrypt16 - Decrypt HASPData Buffer (16Bit)                                *
******************************************************************************
* InBuff - buffer                                                            *
*****************************************************************************/
void Decrypt16(unsigned char *inBuff)
{
unsigned short int rAX,rBX,rCX,rDX,rDI,rSI;
unsigned short int mD1,mD5,mD7,mD9,mDB,mDD;
unsigned char mD3;
unsigned short int *in;

in=inBuff;

rDI=0;

mD1=mD3=mD7=mD9=0;
mDB=0x11;
mDD=0x28/2;
rSI=0;

l1:;
rSI=mD1;
mD5=rAX=in[rSI];
mD3=0;
mD7=0;
l2:;
rBX=mDB;
rCX=mD5;
rBX=rBX ^ rCX;
rBX=rBX & 1;
rSI=rBX;
rCX=mD3;
rSI=rSI << rCX;
rAX=mD7;
rAX=rAX | rSI;
mD7=rAX;
rAX=mD5;
rAX=rAX & 1;
rBX=0x4951;
rAX=rBX*rAX;
rCX=rAX;
rAX=mDB;
if (rAX & 0x8000)
	rAX=(rAX >> 1) | 0x8000;
	else
	rAX=rAX >> 1;

rBX=rAX;
rBX=rBX ^ rCX;
mDB=rBX;

rAX=mD5;
if (rAX & 0x8000)
	rAX=(rAX >> 1) | 0x8000;
	else
	rAX=rAX >> 1;
mD5=rAX;

mD3++;
rAX=0x10;
if (rAX != mD3)
	goto l2;
rAX=mD7;
rSI=mD1;
in[rDI+rSI]=rAX;
mD1=mD1+1;
rAX=mDD;
if (rAX!=mD1)
        goto l1;

//in[rBX-4]=in[rBX-4]+rBX;
}


